<?php

/**
 * FormVitalDetails represents the measurement details for a specific vital sign in the system.
 * For backwards compatibility it extends ORDataObject (which implements the a form of the Active record data pattern),
 * but the preferred mechanism is to use this as a POPO (Plain old PHP object) and save / retrieve data using
 * the VitalsService class.
 * @package openemr
 * @link      http://www.open-emr.org
 * @author    Stephen Nielson <stephen@nielson.org>
 * @copyright Copyright (c) 2021 Stephen Nielson <stephen@nielson.org>
 * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3
 */

namespace OpenEMR\Common\Forms;

use OpenEMR\Common\ORDataObject\ORDataObject;

/**
 * Class FormVitalDetails
 */
class FormVitalDetails extends ORDataObject
{
    /**
     *
     * @access public
     */
    const TABLE_NAME = "form_vital_details";

    private $id;


    /**
     * @var number The unique id of the form (id column in form_vitals and form_id in the forms table).
     */
    private $form_id;

    /**
     * The unique id
     * @var string
     */
    private $uuid;

    /**
     * The name of the vitals column this detail pertains to
     * @var string
     */
    private $vitals_column;

    /**
     * Represents the list_options list id for the vitals interpretation
     * @var string
     */
    private $interpretation_list_id;

    /**
     * Represents the list_options option id for the vitals interpretation
     * @var string
     */
    private $interpretation_option_id;

    /**
     * @var string
     */
    private $interpretation_title;

    /**
     * @var string
     */
    private $interpretation_codes;

    private $reason_code;

    private $reason_status;

    private $reason_description;

    public function __construct()
    {
        parent::__construct(self::TABLE_NAME);
    }

    public function persist()
    {
        return parent::persist(); // TODO: Change the autogenerated stub
    }

    /**
     * @return mixed
     */
    public function get_id()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return FormVitalDetails
     */
    public function set_id($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function get_uuid(): ?string
    {
        return $this->uuid;
    }

    /**
     * @param string $uuid
     * @return FormVitalDetails
     */
    public function set_uuid(string $uuid): FormVitalDetails
    {
        $this->uuid = $uuid;
        return $this;
    }

    /**
     * @return string
     */
    public function get_vitals_column(): ?string
    {
        return $this->vitals_column;
    }

    /**
     * @param string $vitals_column
     * @return FormVitalDetails
     */
    public function set_vitals_column(string $vitals_column): FormVitalDetails
    {
        $this->vitals_column = $vitals_column;
        return $this;
    }

    /**
     * @return string
     */
    public function get_interpretation_list_id(): ?string
    {
        return $this->interpretation_list_id;
    }

    /**
     * @param string $interpretation_list_id
     * @return FormVitalDetails
     */
    public function set_interpretation_list_id(string $interpretation_list_id): FormVitalDetails
    {
        $this->interpretation_list_id = $interpretation_list_id;
        return $this;
    }

    /**
     * @return string
     */
    public function get_interpretation_option_id(): ?string
    {
        return $this->interpretation_option_id;
    }

    /**
     * @param string $interpretation_option_id
     * @return FormVitalDetails
     */
    public function set_interpretation_option_id(string $interpretation_option_id): FormVitalDetails
    {
        $this->interpretation_option_id = $interpretation_option_id;
        return $this;
    }


    /**
     * @return string
     */
    public function get_interpretation_title(): ?string
    {
        return $this->interpretation_title;
    }

    /**
     * @param string $interpretation_title
     * @return FormVitalDetails
     */
    public function set_interpretation_title(string $interpretation_title): FormVitalDetails
    {
        $this->interpretation_title = $interpretation_title;
        return $this;
    }

    /**
     * @return string
     */
    public function get_interpretation_codes(): ?string
    {
        return $this->interpretation_codes;
    }

    /**
     * @param string $interpretation_code
     * @return FormVitalDetails
     */
    public function set_interpretation_codes(string $interpretation_codes): FormVitalDetails
    {
        $this->interpretation_codes = $interpretation_codes;
        return $this;
    }

    public function clear_interpretation()
    {
        $this->interpretation_codes = null;
        $this->interpretation_option_id = null;
        $this->interpretation_list_id = null;
        $this->interpretation_title = null;
    }

    public function set_form_id(?int $form_id)
    {
        $this->form_id = $form_id;
    }

    public function get_form_id(): ?int
    {
        return $this->form_id;
    }

    /**
     * @return string
     */
    public function get_reason_code()
    {
        return $this->reason_code;
    }

    /**
     * @param string $reason_code
     * @return FormVitalDetails
     */
    public function set_reason_code($reason_code)
    {
        $this->reason_code = $reason_code;
        return $this;
    }

    /**
     * @return string
     */
    public function get_reason_status()
    {
        return $this->reason_status;
    }

    /**
     * @param string $reason_status
     * @return FormVitalDetails
     */
    public function set_reason_status($reason_status)
    {
        $this->reason_status = $reason_status;
        return $this;
    }

    /**
     * @return string
     */
    public function get_reason_description()
    {
        return $this->reason_description;
    }

    /**
     * @param string $reason_status_code
     * @return FormVitalDetails
     */
    public function set_reason_description($reason_description)
    {
        $this->reason_description = $reason_description;
        return $this;
    }

    /**
     * Removes all of the reason code, status, and text data
     */
    public function clear_reason()
    {
        $this->reason_code = null;
        $this->reason_status = null;
        $this->reason_description = null;
    }
}
