/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.view;

import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import org.schemaspy.model.Routine;
import org.schemaspy.util.Markdown;
import org.schemaspy.view.MustacheCompiler;
import org.schemaspy.view.PageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlRoutinePage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MustacheCompiler mustacheCompiler;

    public HtmlRoutinePage(MustacheCompiler mustacheCompiler) {
        this.mustacheCompiler = mustacheCompiler;
    }

    public void write(Routine routine, Writer writer) {
        PageData pageData = new PageData.Builder().templateName("routines/routine.html").scriptName("routine.js").addToScope("routineName", (Object)routine.getName()).addToScope("routineComment", (Object)new Markdown(routine.getComment(), this.mustacheCompiler.getRootPath(1)).toHtml()).addToScope("routineParameters", (Object)routine.getParameters()).addToScope("routineDefinition", (Object)routine.getDefinition()).depth(1).getPageData();
        try {
            this.mustacheCompiler.write(pageData, writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write routine page for '{}'", (Object)routine.getName(), (Object)e);
        }
    }
}

