/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.view;

import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.schemaspy.DbAnalyzer;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.Table;
import org.schemaspy.view.MustacheCompiler;
import org.schemaspy.view.PageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlAnomaliesPage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MustacheCompiler mustacheCompiler;

    public HtmlAnomaliesPage(MustacheCompiler mustacheCompiler) {
        this.mustacheCompiler = mustacheCompiler;
    }

    public void write(Collection<Table> tables, List<? extends ForeignKeyConstraint> impliedConstraints, Writer writer) {
        List unIndexedTables = DbAnalyzer.getTablesWithoutIndexes(new HashSet<Table>(tables));
        List impliedConstraintColumns = impliedConstraints.stream().filter(c -> !c.getChildTable().isView()).collect(Collectors.toList());
        List oneColumnTables = DbAnalyzer.getTablesWithOneColumn(tables).stream().filter(t -> !t.isView()).collect(Collectors.toList());
        List incrementingColumnNames = DbAnalyzer.getTablesWithIncrementingColumnNames(tables).stream().filter(t -> !t.isView()).collect(Collectors.toList());
        List uniqueNullables = DbAnalyzer.getDefaultNullStringColumns(new HashSet<Table>(tables));
        PageData pageData = new PageData.Builder().templateName("anomalies.html").scriptName("anomalies.js").addToScope("impliedConstraints", impliedConstraintColumns).addToScope("unIndexedTables", (Object)unIndexedTables).addToScope("oneColumnTables", oneColumnTables).addToScope("incrementingColumnNames", incrementingColumnNames).addToScope("uniqueNullables", (Object)uniqueNullables).depth(0).getPageData();
        try {
            this.mustacheCompiler.write(pageData, writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write anomalies page", (Throwable)e);
        }
    }
}

