/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.util.copy;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.JarURLConnection;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.schemaspy.util.copy.Copy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFromJar
implements Copy {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final JarURLConnection jarConnection;
    private final File destPath;
    private final FileFilter filter;

    public CopyFromJar(JarURLConnection jarConnection, File destPath, FileFilter filter) {
        this.jarConnection = jarConnection;
        this.destPath = destPath;
        this.filter = filter;
    }

    public void copy() {
        try {
            JarFile jarFile = this.jarConnection.getJarFile();
            String jarConnectionEntryName = this.jarConnection.getEntryName();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                String jarEntryName = jarEntry.getName();
                if (!jarEntryName.startsWith(jarConnectionEntryName + "/")) continue;
                String filename = jarEntryName.substring(jarConnectionEntryName.length());
                File currentFile = new File(this.destPath, filename);
                if (jarEntry.isDirectory()) {
                    FileUtils.forceMkdir((File)currentFile);
                    continue;
                }
                if (this.filter != null && !this.filter.accept(currentFile)) continue;
                InputStream is = jarFile.getInputStream(jarEntry);
                try {
                    OutputStream out = Files.newOutputStream(currentFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)out);
                    }
                    finally {
                        if (out == null) continue;
                        out.close();
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }
}

