/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Attributes manifestAttributes = new Attributes();

    private ManifestUtils() {
    }

    public static String getImplementationVersion() {
        return Optional.ofNullable(manifestAttributes.getValue("Implementation-Version")).orElse("IDE");
    }

    public static String getImplementationBuild() {
        return Optional.ofNullable(manifestAttributes.getValue("Implementation-Build")).orElse("IDE");
    }

    static {
        try {
            URL codeSource = ManifestUtils.class.getProtectionDomain().getCodeSource().getLocation();
            URLConnection urlConnection = codeSource.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                manifestAttributes.putAll((Map<?, ?>)((JarURLConnection)urlConnection).getJarFile().getManifest().getMainAttributes());
            } else {
                manifestAttributes.putAll((Map<?, ?>)new JarFile(codeSource.getFile()).getManifest().getMainAttributes());
            }
        }
        catch (IOException ioe) {
            LOGGER.debug("Failed to read manifest", (Throwable)ioe);
        }
    }
}

