/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.xml.dom;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.output.xml.dom.DOMUtil;
import org.schemaspy.output.xml.dom.XmlColumnFormatter;
import org.schemaspy.output.xml.dom.XmlIndexFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlTableFormatter {
    private final XmlColumnFormatter xmlColumnFormatter = new XmlColumnFormatter();
    private final XmlIndexFormatter xmlIndexFormatter = new XmlIndexFormatter();

    public void appendTables(Element schemaNode, Collection<Table> tables) {
        Document document = schemaNode.getOwnerDocument();
        Element tablesNode = document.createElement("tables");
        schemaNode.appendChild(tablesNode);
        tables.stream().sorted((table1, table2) -> table1.getName().compareToIgnoreCase(table2.getName())).distinct().forEachOrdered(t -> this.appendTable(tablesNode, t));
    }

    private void appendTable(Element tablesNode, Table table) {
        Document document = tablesNode.getOwnerDocument();
        Element tableNode = document.createElement("table");
        tablesNode.appendChild(tableNode);
        if (table.getId() != null) {
            DOMUtil.appendAttribute((Node)tableNode, (String)"id", (String)String.valueOf(table.getId()));
        }
        DOMUtil.appendAttribute((Node)tableNode, (String)"catalog", (String)table.getCatalog());
        DOMUtil.appendAttribute((Node)tableNode, (String)"schema", (String)table.getSchema());
        DOMUtil.appendAttribute((Node)tableNode, (String)"name", (String)table.getName());
        if (table.getNumRows() >= 0L) {
            DOMUtil.appendAttribute((Node)tableNode, (String)"numRows", (String)String.valueOf(table.getNumRows()));
        }
        DOMUtil.appendAttribute((Node)tableNode, (String)"type", (String)(table.isView() ? "VIEW" : "TABLE"));
        DOMUtil.appendAttribute((Node)tableNode, (String)"remarks", (String)(table.getComments() == null ? "" : table.getComments()));
        this.xmlColumnFormatter.appendColumns(tableNode, table);
        XmlTableFormatter.appendPrimaryKeys((Element)tableNode, (Table)table);
        this.xmlIndexFormatter.appendIndexes((Node)tableNode, table);
        XmlTableFormatter.appendCheckConstraints((Element)tableNode, (Table)table);
        XmlTableFormatter.appendView((Element)tableNode, (Table)table);
    }

    private static void appendPrimaryKeys(Element tableNode, Table table) {
        Document document = tableNode.getOwnerDocument();
        int index = 1;
        for (TableColumn primaryKeyColumn : table.getPrimaryColumns()) {
            Element primaryKeyNode = document.createElement("primaryKey");
            tableNode.appendChild(primaryKeyNode);
            DOMUtil.appendAttribute((Node)primaryKeyNode, (String)"column", (String)primaryKeyColumn.getName());
            DOMUtil.appendAttribute((Node)primaryKeyNode, (String)"sequenceNumberInPK", (String)String.valueOf(index++));
        }
    }

    private static void appendCheckConstraints(Element tableNode, Table table) {
        Document document = tableNode.getOwnerDocument();
        Map constraints = table.getCheckConstraints();
        if (constraints != null && !constraints.isEmpty()) {
            constraints.forEach((name, value) -> {
                Element constraintNode = document.createElement("checkConstraint");
                tableNode.appendChild(constraintNode);
                DOMUtil.appendAttribute((Node)constraintNode, (String)"name", (String)name);
                DOMUtil.appendAttribute((Node)constraintNode, (String)"constraint", (String)value);
            });
        }
    }

    private static void appendView(Element tableNode, Table table) {
        if (table.isView() && Objects.nonNull(table.getViewDefinition())) {
            DOMUtil.appendAttribute((Node)tableNode, (String)"viewSql", (String)table.getViewDefinition());
        }
    }
}

