/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.xml.dom;

import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.output.xml.dom.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlColumnFormatter {
    private static final int DEFAULT_JDBC_TYPE_CODE = 12;
    private static final Pattern validXmlChars = Pattern.compile("^[ -\ud7ff\ue000-\ufffd\\p{L}\\p{M}\\p{Z}\\p{S}\\p{N}\\p{P}]*$");

    public void appendColumns(Element tableNode, Table table) {
        for (TableColumn column : table.getColumns()) {
            this.appendColumn((Node)tableNode, column);
        }
    }

    public Node appendColumn(Node tableNode, TableColumn column) {
        Document document = tableNode.getOwnerDocument();
        Element columnNode = document.createElement("column");
        tableNode.appendChild(columnNode);
        DOMUtil.appendAttribute((Node)columnNode, (String)"id", (String)String.valueOf(column.getId()));
        DOMUtil.appendAttribute((Node)columnNode, (String)"name", (String)column.getName());
        DOMUtil.appendAttribute((Node)columnNode, (String)"type", (String)column.getTypeName());
        DOMUtil.appendAttribute((Node)columnNode, (String)"typeCode", (String)String.valueOf(column.getType() == null ? 12 : column.getType()));
        DOMUtil.appendAttribute((Node)columnNode, (String)"defaultValue", (String)String.valueOf(column.getDefaultValue()));
        DOMUtil.appendAttribute((Node)columnNode, (String)"size", (String)String.valueOf(column.getLength()));
        DOMUtil.appendAttribute((Node)columnNode, (String)"digits", (String)String.valueOf(column.getDecimalDigits()));
        DOMUtil.appendAttribute((Node)columnNode, (String)"nullable", (String)String.valueOf(column.isNullable()));
        DOMUtil.appendAttribute((Node)columnNode, (String)"autoUpdated", (String)String.valueOf(column.isAutoUpdated()));
        if (column.getDefaultValue() != null) {
            String defaultValue = column.getDefaultValue().toString();
            if (XmlColumnFormatter.isBinary((String)defaultValue)) {
                defaultValue = XmlColumnFormatter.asBinary((String)defaultValue);
                DOMUtil.appendAttribute((Node)columnNode, (String)"defaultValueIsBinary", (String)"true");
            }
            DOMUtil.appendAttribute((Node)columnNode, (String)"defaultValue", (String)defaultValue);
        }
        DOMUtil.appendAttribute((Node)columnNode, (String)"remarks", (String)(column.getComments() == null ? "" : column.getComments()));
        for (TableColumn childColumn : column.getChildren()) {
            Element childNode = document.createElement("child");
            columnNode.appendChild(childNode);
            XmlColumnFormatter.appendForeignKeyAttributes((Node)childNode, (TableColumn)childColumn, (ForeignKeyConstraint)column.getChildConstraint(childColumn));
        }
        for (TableColumn parentColumn : column.getParents()) {
            Element parentNode = document.createElement("parent");
            columnNode.appendChild(parentNode);
            XmlColumnFormatter.appendForeignKeyAttributes((Node)parentNode, (TableColumn)parentColumn, (ForeignKeyConstraint)column.getParentConstraint(parentColumn));
        }
        return columnNode;
    }

    private static void appendForeignKeyAttributes(Node node, TableColumn column, ForeignKeyConstraint foreignKeyConstraint) {
        Table table = column.getTable();
        DOMUtil.appendAttribute((Node)node, (String)"foreignKey", (String)foreignKeyConstraint.getName());
        DOMUtil.appendAttribute((Node)node, (String)"catalog", (String)table.getCatalog());
        DOMUtil.appendAttribute((Node)node, (String)"schema", (String)table.getSchema());
        DOMUtil.appendAttribute((Node)node, (String)"table", (String)table.getName());
        DOMUtil.appendAttribute((Node)node, (String)"column", (String)column.getName());
        DOMUtil.appendAttribute((Node)node, (String)"implied", (String)String.valueOf(foreignKeyConstraint.isImplied()));
        DOMUtil.appendAttribute((Node)node, (String)"onDeleteCascade", (String)String.valueOf(foreignKeyConstraint.isCascadeOnDelete()));
    }

    private static boolean isBinary(String str) {
        return !validXmlChars.matcher(str).matches();
    }

    private static String asBinary(String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            buf.append(String.format("%02X", aByte));
        }
        return buf.toString();
    }
}

