/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.model;

import java.util.ArrayList;
import java.util.List;
import org.schemaspy.model.RoutineParameter;

public class Routine
implements Comparable<Routine> {
    private final String name;
    private final String type;
    private final String definitionLanguage;
    private final String definition;
    private final boolean deterministic;
    private final String dataAccess;
    private final String securityType;
    private final String comment;
    private final String returnType;
    private final List<RoutineParameter> params = new ArrayList();

    public Routine(String name, String type, String returnType, String definitionLanguage, String definition, boolean deterministic, String dataAccess, String securityType, String comment) {
        this.name = name;
        this.type = type;
        this.returnType = returnType;
        this.definitionLanguage = definitionLanguage;
        this.definition = (String)this.coalesce((Object)definition, (Object)"");
        this.dataAccess = dataAccess;
        this.securityType = securityType;
        this.deterministic = deterministic;
        this.comment = comment;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDefinitionLanguage() {
        return this.definitionLanguage;
    }

    public String getDefinition() {
        return this.definition;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public String getDataAccess() {
        return this.dataAccess;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public String getComment() {
        return this.comment;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void addParameter(RoutineParameter param) {
        this.params.add(param);
    }

    public List<RoutineParameter> getParameters() {
        return this.params;
    }

    @Override
    public int compareTo(Routine other) {
        int rc = this.getName().compareTo(other.getName());
        if (rc == 0) {
            rc = this.getType().compareTo(other.getType());
        }
        if (rc == 0) {
            rc = String.valueOf(this.getReturnType()).compareTo(String.valueOf(other.getReturnType()));
        }
        if (rc == 0) {
            rc = this.getDefinition().compareTo(other.getDefinition());
        }
        return rc;
    }

    private <T> T coalesce(T a, T b) {
        return a != null ? a : b;
    }
}

