/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.model;

import java.util.Set;
import org.schemaspy.model.TableColumn;

public class DatabaseObject
implements Comparable<DatabaseObject> {
    private String name;
    private final String fullName;
    private final String typeName;
    private final Integer type;
    private final int length;
    private final Set<TableColumn> parents;
    private final Set<TableColumn> children;

    public DatabaseObject(TableColumn object) {
        this.name = object.getName();
        this.fullName = object.getTable().getFullName() + "." + object.getName();
        this.typeName = object.getTypeName();
        this.type = object.getType();
        this.length = object.getLength();
        this.parents = object.getParents();
        this.children = object.getChildren();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Integer getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public Set<TableColumn> getParents() {
        return this.parents;
    }

    public Set<TableColumn> getChildren() {
        return this.children;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(DatabaseObject column2) {
        int rc = this.getFullName().compareToIgnoreCase(column2.getFullName());
        if (rc == 0) {
            rc = this.getType() != null && column2.getType() != null ? this.getType().compareTo(column2.getType()) : this.getTypeName().compareToIgnoreCase(column2.getTypeName());
        }
        if (rc == 0) {
            rc = this.getLength() - column2.getLength();
        }
        return rc;
    }
}

