/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.model;

import java.io.File;
import java.util.Collection;
import org.schemaspy.cli.CommandLineArguments;
import org.schemaspy.model.ProgressListener;
import org.schemaspy.model.Table;

public class Console
implements ProgressListener {
    private final CommandLineArguments commandLineArguments;
    private final ProgressListener origin;

    public Console(CommandLineArguments commandLineArguments, ProgressListener origin) {
        this.commandLineArguments = commandLineArguments;
        this.origin = origin;
    }

    public void startedGatheringDetails() {
        this.origin.startedGatheringDetails();
        System.out.print("Gathering schema details...");
    }

    public void gatheringDetailsProgressed(Table table) {
        this.origin.gatheringDetailsProgressed(table);
        System.out.print('.');
    }

    public long startedConnectingTables() {
        long result = this.origin.startedConnectingTables();
        System.err.flush();
        System.out.flush();
        System.out.println("(" + result / 1000L + "sec)");
        System.out.print("Connecting relationships...");
        return result;
    }

    public void connectingTablesProgressed(Table table) {
        this.origin.connectingTablesProgressed(table);
        System.out.print('.');
    }

    public long startedGraphingSummaries() {
        long result = this.origin.startedGraphingSummaries();
        System.err.flush();
        System.out.flush();
        System.out.println("(" + result / 1000L + "sec)");
        System.out.print("Writing/graphing summary");
        System.out.print('.');
        return result;
    }

    public void graphingSummaryProgressed() {
        this.origin.graphingSummaryProgressed();
        System.out.print('.');
    }

    public long startedGraphingDetails() {
        long result = this.origin.startedGraphingDetails();
        System.err.flush();
        System.out.flush();
        System.out.println("(" + result / 1000L + "sec)");
        System.out.print("Writing/diagramming details");
        return result;
    }

    public void graphingDetailsProgressed(Table table) {
        this.origin.graphingDetailsProgressed(table);
        System.out.print('.');
    }

    public long finishedGatheringDetails() {
        long result = this.origin.finishedGatheringDetails();
        System.err.flush();
        System.out.flush();
        System.out.println("(" + result / 1000L + "sec)");
        return result;
    }

    public long finished(Collection<Table> tables) {
        long result = this.origin.finished(tables);
        System.err.flush();
        System.out.flush();
        System.out.println("Wrote relationship details of " + tables.size() + " tables/views to directory '" + this.commandLineArguments.getOutputDirectory() + "' in " + result / 1000L + " seconds.");
        System.out.println("View the results by opening " + new File(this.commandLineArguments.getOutputDirectory(), "index.html"));
        return result;
    }
}

