/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms;

import java.lang.invoke.MethodHandles;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Objects;
import org.schemaspy.model.InvalidConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private DatabaseMetaData databaseMetaData;

    public SchemaResolver(DatabaseMetaData databaseMetaData) {
        this.databaseMetaData = databaseMetaData;
    }

    public String resolveSchema(String currentSchema) {
        if (Objects.isNull(currentSchema)) {
            String schema = null;
            try {
                schema = this.databaseMetaData.getConnection().getSchema();
                LOGGER.debug("Schema not provided, queried jdbc driver and got '{}'", (Object)schema);
            }
            catch (SQLException sqle) {
                LOGGER.error("Schema (-s/-schemas) not provided, queried jdbc driver for schema and failed", (Throwable)sqle);
            }
            if (Objects.isNull(schema)) {
                throw new InvalidConfigurationException("Schema (-s/-schemas) was not provided and unable to deduce schema, schema is sometimes referred to as user/owner/database");
            }
            return schema;
        }
        return currentSchema;
    }
}

