/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.schemaspy.input.dbms.exceptions.RuntimeIOException;

public class DatabaseTypes {
    private Set<String> builtInTypes;

    public synchronized Set<String> getBuiltInDatabaseTypes() {
        if (Objects.isNull(this.builtInTypes)) {
            Enumeration typesFolders = this.urlsForTypesFolders();
            this.builtInTypes = new HashSet();
            while (typesFolders.hasMoreElements()) {
                URL typeFolder = (URL)typesFolders.nextElement();
                Path typeFolderPath = this.asPath(typeFolder);
                this.builtInTypes.addAll(this.collectDbTypes(typeFolderPath));
            }
        }
        return this.builtInTypes;
    }

    private Enumeration<URL> urlsForTypesFolders() {
        try {
            return this.getClass().getClassLoader().getResources("org/schemaspy/types");
        }
        catch (IOException e) {
            throw new RuntimeIOException("Unable to retrieve urls for type folders", (Throwable)e);
        }
    }

    private Path asPath(URL typeFolder) {
        try {
            if (typeFolder.getProtocol().equalsIgnoreCase("file")) {
                return Paths.get(typeFolder.toURI());
            }
            this.ensureFileSystemExists(typeFolder);
            URI uri = URI.create(typeFolder.toString().replace("classes!", "classes"));
            return Paths.get(uri);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeIOException("Unable to create Path for '" + typeFolder + "'", (Throwable)e);
        }
    }

    private void ensureFileSystemExists(URL url) throws URISyntaxException, IOException {
        try {
            FileSystems.getFileSystem(url.toURI());
        }
        catch (FileSystemNotFoundException notFound) {
            FileSystems.newFileSystem(url.toURI(), Collections.singletonMap("create", "false"));
        }
    }

    private Set<String> collectDbTypes(Path typeFolderPath) {
        Set<String> set;
        block8: {
            Stream<Path> pathStream = Files.list(typeFolderPath);
            try {
                set = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).filter(name -> name.matches(".*\\.properties$")).map(name -> name.replaceAll("\\.properties$", "")).collect(Collectors.toSet());
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Unable to retrieve dbtypes from '" + typeFolderPath + "'", (Throwable)e);
                }
            }
            pathStream.close();
        }
        return set;
    }
}

