/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.schemaspy.input.dbms.ConnectionConfig;
import org.schemaspy.input.dbms.DatabaseTypeConfig;
import org.schemaspy.util.DbSpecificConfig;

@Parameters(resourceBundle="connectionconfigcli")
public class ConnectionConfigCli
implements ConnectionConfig {
    @Parameter(names={"-db", "--database-name", "schemaspy.db", "schemaspy.database-name"}, descriptionKey="databaseName")
    private String databaseName;
    @Parameter(names={"-host", "--host", "schemaspy.host"}, descriptionKey="host")
    private String host;
    @Parameter(names={"-port", "--port", "schemaspy.port"}, descriptionKey="port")
    private Integer port;
    @Parameter(names={"-u", "--user", "schemaspy.u", "schemaspy.user"}, descriptionKey="user")
    private String user;
    @Parameter(names={"-p", "--password", "schemaspy.p", "schemaspy.pw", "schemaspy.password"}, descriptionKey="password")
    private String password;
    @Parameter(names={"-pfp", "--prompt-for-password", "schemaspy.pfp"}, descriptionKey="pfp", password=true)
    private String passwordFromPrompt;
    @Parameter(names={"-connprops", "schemaspy.connprops"}, descriptionKey="connprops")
    private String connprops = null;
    @Parameter(names={"-dp", "--driverPath", "schemaspy.dp", "schemaspy.driverPath"}, descriptionKey="driverPath")
    private String driverPath;
    @Parameter(names={"-loadjars", "--load-sibling-jars", "schemaspy.loadjars", "schemaspy.load-sibling-jars"}, descriptionKey="loadsiblings")
    private boolean loadSiblings = false;
    private final DatabaseTypeConfig databaseTypeConfig;
    private List<String> remainingArguments = Collections.emptyList();

    public ConnectionConfigCli(DatabaseTypeConfig databaseTypeConfig) {
        this.databaseTypeConfig = databaseTypeConfig;
    }

    public String getDatabaseType() {
        return this.databaseTypeConfig.getType();
    }

    public Properties getDatabaseTypeProperties() {
        return this.databaseTypeConfig.getProperties();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        if (Objects.nonNull(this.passwordFromPrompt)) {
            return this.passwordFromPrompt;
        }
        return this.password;
    }

    public String getConnectionProperties() {
        return this.connprops;
    }

    public DbSpecificConfig getDbSpecificConfig() {
        return new DbSpecificConfig(this.getDatabaseType(), this.getDatabaseTypeProperties());
    }

    public String getDriverPath() {
        return this.driverPath;
    }

    public boolean withLoadSiblings() {
        return this.loadSiblings;
    }

    public void setRemainingArguments(List<String> remainingArguments) {
        this.remainingArguments = remainingArguments;
    }

    public List<String> getRemainingArguments() {
        return new ArrayList<String>(this.remainingArguments);
    }
}

