/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.cli;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.JarFile;
import org.schemaspy.input.dbms.exceptions.RuntimeIOException;

public class SchemaSpyJarFile {
    public Path path() {
        URL location = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        try {
            return this.findSource(location);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeIOException("Unable to get SchemaSpy-jarFile path", (Throwable)e);
        }
    }

    private Path findSource(URL location) throws IOException, URISyntaxException {
        URLConnection connection = location.openConnection();
        return connection instanceof JarURLConnection ? this.getRootJarFile(((JarURLConnection)connection).getJarFile()) : Paths.get(location.toURI());
    }

    private Path getRootJarFile(JarFile jarFile) {
        String name = jarFile.getName();
        int separator = name.indexOf("!/");
        if (separator > 0) {
            name = name.substring(0, separator);
        }
        return Paths.get(name, new String[0]);
    }
}

