/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.schemaspy.DbAnalyzer;
import org.schemaspy.InsertionOrdered;
import org.schemaspy.LayoutFolder;
import org.schemaspy.OrderingReport;
import org.schemaspy.SimpleRuntimeDotConfig;
import org.schemaspy.analyzer.ImpliedConstraintsFinder;
import org.schemaspy.cli.CommandLineArguments;
import org.schemaspy.input.dbms.CatalogResolver;
import org.schemaspy.input.dbms.DbDriverLoader;
import org.schemaspy.input.dbms.SchemaResolver;
import org.schemaspy.input.dbms.service.DatabaseService;
import org.schemaspy.input.dbms.service.DatabaseServiceFactory;
import org.schemaspy.input.dbms.service.SqlService;
import org.schemaspy.input.dbms.xml.SchemaMeta;
import org.schemaspy.model.Console;
import org.schemaspy.model.Database;
import org.schemaspy.model.DbmsMeta;
import org.schemaspy.model.EmptySchemaException;
import org.schemaspy.model.ProgressListener;
import org.schemaspy.model.Routine;
import org.schemaspy.model.Table;
import org.schemaspy.model.Tracked;
import org.schemaspy.output.OutputException;
import org.schemaspy.output.OutputProducer;
import org.schemaspy.output.diagram.Renderer;
import org.schemaspy.output.diagram.SummaryDiagram;
import org.schemaspy.output.diagram.TableDiagram;
import org.schemaspy.output.diagram.graphviz.GraphvizDot;
import org.schemaspy.output.diagram.vizjs.VizJSDot;
import org.schemaspy.output.dot.RuntimeDotConfig;
import org.schemaspy.output.dot.schemaspy.DefaultFontConfig;
import org.schemaspy.output.dot.schemaspy.DotFormatter;
import org.schemaspy.output.dot.schemaspy.FontConfig;
import org.schemaspy.output.dot.schemaspy.OrphanGraph;
import org.schemaspy.output.dot.schemaspy.graph.Graph;
import org.schemaspy.output.html.mustache.Diagram;
import org.schemaspy.output.html.mustache.diagrams.MustacheSummaryDiagramFactory;
import org.schemaspy.output.html.mustache.diagrams.MustacheSummaryDiagramResults;
import org.schemaspy.output.html.mustache.diagrams.MustacheTableDiagramFactory;
import org.schemaspy.output.html.mustache.diagrams.OrphanDiagram;
import org.schemaspy.util.DataTableConfig;
import org.schemaspy.util.DefaultPrintWriter;
import org.schemaspy.util.ManifestUtils;
import org.schemaspy.util.Markdown;
import org.schemaspy.util.copy.CopyFromUrl;
import org.schemaspy.util.naming.FileNameGenerator;
import org.schemaspy.view.HtmlAnomaliesPage;
import org.schemaspy.view.HtmlColumnsPage;
import org.schemaspy.view.HtmlConstraintsPage;
import org.schemaspy.view.HtmlMainIndexPage;
import org.schemaspy.view.HtmlMultipleSchemasIndexPage;
import org.schemaspy.view.HtmlOrphansPage;
import org.schemaspy.view.HtmlRelationshipsPage;
import org.schemaspy.view.HtmlRoutinePage;
import org.schemaspy.view.HtmlRoutinesPage;
import org.schemaspy.view.HtmlTablePage;
import org.schemaspy.view.MustacheCatalog;
import org.schemaspy.view.MustacheCompiler;
import org.schemaspy.view.MustacheSchema;
import org.schemaspy.view.SqlAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchemaAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int SECONDS_IN_MS = 1000;
    private static final String DOT_HTML = ".html";
    private static final String INDEX_DOT_HTML = "index.html";
    private final SqlService sqlService;
    private final DatabaseServiceFactory databaseServiceFactory;
    private final CommandLineArguments commandLineArguments;
    private final OutputProducer outputProducer;
    private final LayoutFolder layoutFolder;

    public SchemaAnalyzer(SqlService sqlService, DatabaseServiceFactory databaseServiceFactory, CommandLineArguments commandLineArguments, OutputProducer outputProducer, LayoutFolder layoutFolder) {
        this.sqlService = Objects.requireNonNull(sqlService);
        this.databaseServiceFactory = databaseServiceFactory;
        this.commandLineArguments = Objects.requireNonNull(commandLineArguments);
        this.outputProducer = outputProducer;
        this.layoutFolder = layoutFolder;
    }

    public Database analyze() throws SQLException, IOException {
        Tracked progressListener = new Tracked();
        if (this.commandLineArguments.isHtmlEnabled()) {
            progressListener = new Console(this.commandLineArguments, (ProgressListener)progressListener);
        }
        if (this.commandLineArguments.isEvaluateAllEnabled() || !this.commandLineArguments.getSchemas().isEmpty()) {
            return this.analyzeMultipleSchemas(this.databaseServiceFactory.forMultipleSchemas(this.commandLineArguments.getProcessingConfig()), (ProgressListener)progressListener);
        }
        File outputDirectory = this.commandLineArguments.getOutputDirectory();
        Objects.requireNonNull(outputDirectory);
        String schema = this.commandLineArguments.getSchema();
        return this.analyze(this.commandLineArguments.getConnectionConfig().getDatabaseName(), schema, false, outputDirectory, this.databaseServiceFactory.forSingleSchema(this.commandLineArguments.getProcessingConfig()), (ProgressListener)progressListener);
    }

    public Database analyzeMultipleSchemas(DatabaseService databaseService, ProgressListener progressListener) throws SQLException, IOException {
        List schemas = this.commandLineArguments.getSchemas();
        Database db = null;
        Connection connection = new DbDriverLoader(this.commandLineArguments.getConnectionConfig()).getConnection();
        DatabaseMetaData meta = connection.getMetaData();
        if (schemas.isEmpty()) {
            String schemaSpec = this.commandLineArguments.getSchemaSpec();
            LOGGER.info("Analyzing schemas that match regular expression '{}'. (use -schemaSpec on command line or in .properties to exclude other schemas)", (Object)schemaSpec);
            schemas = DbAnalyzer.getPopulatedSchemas((DatabaseMetaData)meta, (String)schemaSpec, (boolean)false);
            if (schemas.isEmpty()) {
                schemas = DbAnalyzer.getPopulatedSchemas((DatabaseMetaData)meta, (String)schemaSpec, (boolean)true);
            }
            if (schemas.isEmpty()) {
                schemas.add(this.commandLineArguments.getConnectionConfig().getUser());
            }
        }
        LOGGER.info("Analyzing schemas: {}{}", (Object)System.lineSeparator(), (Object)schemas.stream().map(s -> String.format("'%s'", s)).collect(Collectors.joining(System.lineSeparator())));
        File outputDir = this.commandLineArguments.getOutputDirectory();
        ArrayList<MustacheSchema> mustacheSchemas = new ArrayList<MustacheSchema>();
        MustacheCatalog mustacheCatalog = null;
        for (String schema : schemas) {
            String dbName = Objects.nonNull(this.commandLineArguments.getConnectionConfig().getDatabaseName()) ? this.commandLineArguments.getConnectionConfig().getDatabaseName() : schema;
            LOGGER.info("Analyzing '{}'", (Object)schema);
            File outputDirForSchema = new File(outputDir, new FileNameGenerator(schema).value());
            db = this.analyze(dbName, schema, true, outputDirForSchema, databaseService, progressListener);
            if (db == null) {
                return null;
            }
            mustacheSchemas.add(new MustacheSchema(db.getSchema(), ""));
            mustacheCatalog = new MustacheCatalog(db.getCatalog(), "");
        }
        new CopyFromUrl(this.layoutFolder.url(), outputDir, this.notHtml()).copy();
        DataTableConfig dataTableConfig = new DataTableConfig(this.commandLineArguments);
        MustacheCompiler mustacheCompiler = new MustacheCompiler(this.commandLineArguments.getConnectionConfig().getDatabaseName(), null, this.commandLineArguments.getHtmlConfig(), true, dataTableConfig);
        HtmlMultipleSchemasIndexPage htmlMultipleSchemasIndexPage = new HtmlMultipleSchemasIndexPage(mustacheCompiler);
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("index.html").toFile());){
            htmlMultipleSchemasIndexPage.write(mustacheCatalog, mustacheSchemas, this.commandLineArguments.getHtmlConfig().getDescription(), SchemaAnalyzer.getDatabaseProduct((DatabaseMetaData)meta), (Writer)writer);
        }
        return db;
    }

    private static String getDatabaseProduct(DatabaseMetaData meta) {
        try {
            return meta.getDatabaseProductName() + " - " + meta.getDatabaseProductVersion();
        }
        catch (SQLException exc) {
            return "";
        }
    }

    public Database analyze(String dbName, String schema, boolean isOneOfMultipleSchemas, File outputDir, DatabaseService databaseService, ProgressListener progressListener) throws SQLException, IOException {
        SchemaMeta schemaMeta;
        LOGGER.info("Starting schema analysis");
        FileUtils.forceMkdir((File)outputDir);
        String catalog = this.commandLineArguments.getCatalog();
        DatabaseMetaData databaseMetaData = this.sqlService.connect(this.commandLineArguments.getConnectionConfig());
        DbmsMeta dbmsMeta = this.sqlService.getDbmsMeta();
        LOGGER.debug("supportsSchemasInTableDefinitions: {}", (Object)databaseMetaData.supportsSchemasInTableDefinitions());
        LOGGER.debug("supportsCatalogsInTableDefinitions: {}", (Object)databaseMetaData.supportsCatalogsInTableDefinitions());
        catalog = new CatalogResolver(databaseMetaData).resolveCatalog(catalog);
        schema = new SchemaResolver(databaseMetaData).resolveSchema(schema);
        SchemaMeta schemaMeta2 = schemaMeta = this.commandLineArguments.getSchemaMeta() == null ? null : new SchemaMeta(this.commandLineArguments.getSchemaMeta(), dbName, schema, isOneOfMultipleSchemas);
        if (this.commandLineArguments.isHtmlEnabled()) {
            FileUtils.forceMkdir((File)new File(outputDir, "tables"));
            FileUtils.forceMkdir((File)new File(outputDir, "diagrams/summary"));
            LOGGER.info("Connected to {} - {}", (Object)databaseMetaData.getDatabaseProductName(), (Object)databaseMetaData.getDatabaseProductVersion());
            if (schemaMeta != null && schemaMeta.getFile() != null) {
                LOGGER.info("Using additional metadata from {}", (Object)schemaMeta.getFile());
            }
        }
        Database db = new Database(dbmsMeta, dbName, catalog, schema);
        databaseService.gatherSchemaDetails(db, schemaMeta, progressListener);
        ArrayList tables = new ArrayList(db.getTables());
        tables.addAll(db.getViews());
        if (tables.isEmpty()) {
            SchemaAnalyzer.dumpNoTablesMessage((String)schema, (String)this.commandLineArguments.getConnectionConfig().getUser(), (DatabaseMetaData)databaseMetaData, (!".*".equals(this.commandLineArguments.getProcessingConfig().getTableInclusions().toString()) ? 1 : 0) != 0);
            if (!isOneOfMultipleSchemas) {
                throw new EmptySchemaException();
            }
        }
        long duration = progressListener.startedGraphingSummaries();
        if (this.commandLineArguments.isHtmlEnabled()) {
            this.generateHtmlDoc(schema, isOneOfMultipleSchemas, this.commandLineArguments.useVizJS(), progressListener, outputDir, db, duration, tables);
        }
        try {
            this.outputProducer.generate(db, outputDir);
        }
        catch (OutputException oe) {
            if (isOneOfMultipleSchemas) {
                LOGGER.warn("Failed to produce output", (Throwable)oe);
            }
            throw oe;
        }
        List orderedTables = new InsertionOrdered(db).getTablesOrderedByRI();
        new OrderingReport(outputDir, orderedTables).write();
        duration = progressListener.finishedGatheringDetails();
        long overallDuration = progressListener.finished(tables);
        if (this.commandLineArguments.isHtmlEnabled()) {
            LOGGER.info("Wrote table details in {} seconds", (Object)(duration / 1000L));
            LOGGER.info("Wrote relationship details of {} tables/views to directory '{}' in {} seconds.", new Object[]{tables.size(), outputDir, overallDuration / 1000L});
            LOGGER.info("View the results by opening {}", (Object)new File(outputDir, "index.html"));
        }
        return db;
    }

    private void generateHtmlDoc(String schema, boolean isOneOfMultipleSchemas, boolean useVizJS, ProgressListener progressListener, File outputDir, Database db, long duration, Collection<Table> tables) throws IOException {
        boolean hasRealConstraints;
        LOGGER.info("Gathered schema details in {} seconds", (Object)(duration / 1000L));
        LOGGER.info("Writing/graphing summary");
        Markdown.registryPage(tables);
        new CopyFromUrl(this.layoutFolder.url(), outputDir, this.notHtml()).copy();
        VizJSDot renderer = useVizJS ? new VizJSDot() : new GraphvizDot(this.commandLineArguments.getGraphVizConfig());
        Path htmlInfoFile = outputDir.toPath().resolve("info-html.txt");
        Files.deleteIfExists(htmlInfoFile);
        SchemaAnalyzer.writeInfo((String)"date", (String)ZonedDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssZ")), (Path)htmlInfoFile);
        SchemaAnalyzer.writeInfo((String)"os", (String)(System.getProperty("os.name") + " " + System.getProperty("os.version")), (Path)htmlInfoFile);
        SchemaAnalyzer.writeInfo((String)"schemaspy-version", (String)ManifestUtils.getImplementationVersion(), (Path)htmlInfoFile);
        SchemaAnalyzer.writeInfo((String)"schemaspy-build", (String)ManifestUtils.getImplementationBuild(), (Path)htmlInfoFile);
        SchemaAnalyzer.writeInfo((String)"renderer", (String)renderer.identifier(), (Path)htmlInfoFile);
        progressListener.graphingSummaryProgressed();
        boolean bl = hasRealConstraints = !db.getRemoteTables().isEmpty() || tables.stream().anyMatch(table -> !table.isOrphan(false));
        if (this.commandLineArguments.isRailsEnabled()) {
            DbAnalyzer.getRailsConstraints((Map)db.getTablesMap());
        }
        ImpliedConstraintsFinder impliedConstraintsFinder = new ImpliedConstraintsFinder();
        List impliedConstraints = this.commandLineArguments.withImpliedRelationships() ? impliedConstraintsFinder.find(tables) : Collections.emptyList();
        SimpleRuntimeDotConfig runtimeDotConfig = new SimpleRuntimeDotConfig((FontConfig)new DefaultFontConfig(this.commandLineArguments.getDotConfig()), this.commandLineArguments.getDotConfig(), "svg".equalsIgnoreCase(renderer.format()), isOneOfMultipleSchemas);
        DotFormatter dotProducer = new DotFormatter((RuntimeDotConfig)runtimeDotConfig);
        File diagramDir = new File(outputDir, "diagrams");
        diagramDir.mkdirs();
        File summaryDir = new File(diagramDir, "summary");
        summaryDir.mkdirs();
        SummaryDiagram summaryDiagram = new SummaryDiagram((Renderer)renderer, summaryDir);
        MustacheSummaryDiagramFactory mustacheSummaryDiagramFactory = new MustacheSummaryDiagramFactory(dotProducer, summaryDiagram, hasRealConstraints, !impliedConstraints.isEmpty(), outputDir);
        MustacheSummaryDiagramResults results = mustacheSummaryDiagramFactory.generateSummaryDiagrams(db, tables, progressListener);
        results.getOutputExceptions().stream().forEachOrdered(exception -> LOGGER.error("RelationShipDiagramError", (Throwable)exception));
        DataTableConfig dataTableConfig = new DataTableConfig(this.commandLineArguments);
        MustacheCompiler mustacheCompiler = new MustacheCompiler(db.getName(), schema, this.commandLineArguments.getHtmlConfig(), isOneOfMultipleSchemas, dataTableConfig);
        HtmlRelationshipsPage htmlRelationshipsPage = new HtmlRelationshipsPage(mustacheCompiler, hasRealConstraints, !impliedConstraints.isEmpty());
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("relationships.html").toFile());){
            htmlRelationshipsPage.write(results, (Writer)writer);
        }
        progressListener.graphingSummaryProgressed();
        HtmlOrphansPage htmlOrphansPage = new HtmlOrphansPage(mustacheCompiler, (Diagram)new OrphanDiagram((Graph)new OrphanGraph((RuntimeDotConfig)runtimeDotConfig, tables), (Renderer)renderer, outputDir));
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("orphans.html").toFile());){
            htmlOrphansPage.write((Writer)writer);
        }
        progressListener.graphingSummaryProgressed();
        HtmlMainIndexPage htmlMainIndexPage = new HtmlMainIndexPage(mustacheCompiler, this.commandLineArguments.getHtmlConfig().getDescription());
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("index.html").toFile());){
            htmlMainIndexPage.write(db, tables, impliedConstraints, (Writer)writer);
        }
        progressListener.graphingSummaryProgressed();
        List constraints = DbAnalyzer.getForeignKeyConstraints(tables);
        HtmlConstraintsPage htmlConstraintsPage = new HtmlConstraintsPage(mustacheCompiler);
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("constraints.html").toFile());){
            htmlConstraintsPage.write(constraints, tables, (Writer)writer);
        }
        progressListener.graphingSummaryProgressed();
        HtmlAnomaliesPage htmlAnomaliesPage = new HtmlAnomaliesPage(mustacheCompiler);
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("anomalies.html").toFile());){
            htmlAnomaliesPage.write(tables, impliedConstraints, (Writer)writer);
        }
        progressListener.graphingSummaryProgressed();
        HtmlColumnsPage htmlColumnsPage = new HtmlColumnsPage(mustacheCompiler);
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("columns.html").toFile());){
            htmlColumnsPage.write(tables, (Writer)writer);
        }
        progressListener.graphingSummaryProgressed();
        HtmlRoutinesPage htmlRoutinesPage = new HtmlRoutinesPage(mustacheCompiler);
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("routines.html").toFile());){
            htmlRoutinesPage.write(db.getRoutines(), (Writer)writer);
        }
        HtmlRoutinePage htmlRoutinePage = new HtmlRoutinePage(mustacheCompiler);
        for (Routine routine : db.getRoutines()) {
            try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("routines").resolve(new FileNameGenerator(routine.getName()).value() + ".html").toFile());){
                htmlRoutinePage.write(routine, (Writer)writer);
            }
        }
        duration = progressListener.startedGraphingDetails();
        LOGGER.info("Completed summary in {} seconds", (Object)(duration / 1000L));
        LOGGER.info("Writing/diagramming details");
        SqlAnalyzer sqlAnalyzer = new SqlAnalyzer(db.getDbmsMeta().getIdentifierQuoteString(), db.getDbmsMeta().getAllKeywords(), db.getTables(), db.getViews());
        File tablesDir = new File(diagramDir, "tables");
        tablesDir.mkdirs();
        TableDiagram tableDiagram = new TableDiagram((Renderer)renderer, tablesDir);
        MustacheTableDiagramFactory mustacheTableDiagramFactory = new MustacheTableDiagramFactory(dotProducer, tableDiagram, outputDir, this.commandLineArguments.getDegreeOfSeparation());
        HtmlTablePage htmlTablePage = new HtmlTablePage(mustacheCompiler, sqlAnalyzer);
        for (Table table2 : tables) {
            List mustacheTableDiagrams = mustacheTableDiagramFactory.generateTableDiagrams(table2);
            progressListener.graphingDetailsProgressed(table2);
            LOGGER.debug("Writing details of {}", (Object)table2.getName());
            try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("tables").resolve(new FileNameGenerator(table2.getName()).value() + ".html").toFile());){
                htmlTablePage.write(table2, mustacheTableDiagrams, (Writer)writer);
            }
        }
    }

    private FileFilter notHtml() {
        IOFileFilter notHtmlFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".html"));
        return FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{notHtmlFilter});
    }

    private static void writeInfo(String key, String value, Path infoFile) {
        try {
            Files.write(infoFile, (key + "=" + value + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write '{}', to '{}'", new Object[]{key + "=" + value, infoFile, e});
        }
    }

    private static void dumpNoTablesMessage(String schema, String user, DatabaseMetaData meta, boolean specifiedInclusions) throws SQLException {
        List schemas;
        LOGGER.warn("No tables or views were found in schema '{}'.", (Object)schema);
        try {
            schemas = DbAnalyzer.getSchemas((DatabaseMetaData)meta);
        }
        catch (RuntimeException | SQLException exc) {
            LOGGER.error("The user you specified '{}' might not have rights to read the database metadata.", (Object)user, (Object)exc);
            return;
        }
        if (Objects.isNull(schemas)) {
            LOGGER.error("Failed to retrieve any schemas");
        } else if (schemas.contains(schema)) {
            LOGGER.error("The schema exists in the database, but the user you specified '{}'might not have rights to read its contents.", (Object)user);
            if (specifiedInclusions) {
                LOGGER.error("Another possibility is that the regular expression that you specified for what to include (via -i) didn't match any tables.");
            }
        } else {
            LOGGER.error("The schema '{}' could not be read/found, schema is specified using the -s option.Make sure user '{}' has the correct privileges to read the schema.Also not that schema names are usually case sensitive.", (Object)schema, (Object)user);
            LOGGER.info("Available schemas(Some of these may be user or system schemas):{}{}", (Object)System.lineSeparator(), (Object)schemas.stream().collect(Collectors.joining(System.lineSeparator())));
            List populatedSchemas = DbAnalyzer.getPopulatedSchemas((DatabaseMetaData)meta);
            if (populatedSchemas.isEmpty()) {
                LOGGER.error("Unable to determine if any of the schemas contain tables/views");
            } else {
                LOGGER.info("Schemas with tables/views visible to '{}':{}{}", new Object[]{user, System.lineSeparator(), populatedSchemas.stream().map(s -> String.format("'%s'", s)).collect(Collectors.joining(System.lineSeparator()))});
            }
        }
    }
}

